{
 -------------------------------------------------------------------------
 Copyright (C) 1998-2003 Hger+Busch                   / >>>>>>>>> /-----
 Ingenieurbuero fuer Kommunikationslsungen           / <<<<<<<<< /
 ----------------------------------------------------/ >>>>>>>>> /
 All rights reserved.
                                                    http://www.commso.com

 Project     : hbTapi Components
 Modul       : Sample FaxHandoff

 Description : This sample shows how to pass a call to another application.

 History     : [-] Fixed [+] Added [*] Improved

 01/01/03   Creation
}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, hbTAPI, Tapi, ExtCtrls;

type
  TForm1 = class(TForm)
    CheckBoxActive: TCheckBox;
    ComboBoxDevice: TComboBox;
    EditApplication: TEdit;
    ButtonAnswer: TButton;
    ButtonHangup: TButton;
    ButtonClear: TButton;
    Memo1: TMemo;
    LabelApplication: TLabel;
    TapiLine1: TTapiLine;
    procedure CheckBoxActiveClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ComboBoxDeviceChange(Sender: TObject);
    procedure ButtonAnswerClick(Sender: TObject);
    procedure ButtonHangupClick(Sender: TObject);
    procedure ButtonClearClick(Sender: TObject);
    procedure TapiLine1MediaMode(Sender: TTapiLine; Call: TTapiCall);
    procedure TapiLine1Connected(Sender: TTapiLine; Call: TTapiCall);
    procedure TapiLine1Idle(Sender: TTapiLine; Call: TTapiCall);
    procedure TapiLine1Ring(Sender: TTapiLine; RingMode,
      RingCount: Cardinal);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.CheckBoxActiveClick(Sender: TObject);
begin
  if not CheckBoxActive.Checked then
    begin
      if TapiLine1.Active then
        begin
          Memo1.Lines.Add('TapiLine1.Active = False');
          try
            TapiLine1.Active := False;
          except
            CheckBoxActive.Checked := True;
            raise;
          end;
        end;
    end
  else
  begin
    if not TapiLine1.Active then
    begin
      Memo1.Lines.Add('TapiLine1.Active = True');
      try
        TapiLine1.Active := True;
      except
        on E:ETapiError do
        begin
          if E.ErrorCode = LINEERR_INVALMEDIAMODE then
          begin
            Memo1.Lines.Add(#9 + 'This device is not 100% TAPI compliant');
            TapiLine1.MediaModes := LINEMEDIAMODE_DATAMODEM;
            try
              TapiLine1.Active := True;
            except
              Memo1.Lines.Add(#9 + 'Error = ' + E.Message);
              CheckBoxActive.Checked := False;
            end;
          end
          else
            CheckBoxActive.Checked := False;
        end;
      end;
    end;
  end;
end;

{------------------------------------------------------------------------------}
{ FormCreate
{------------------------------------------------------------------------------}
procedure TForm1.FormCreate(Sender: TObject);
begin
  ComboBoxDevice.Items := TapiLine1.DeviceList;
  if ComboBoxDevice.Items.Count > 0 then
    ComboBoxDevice.Text := ComboBoxDevice.Items[0];
  ComboBoxDevice.ItemIndex := 0;
end;

{------------------------------------------------------------------------------}
{ ComboBoxDeviceChange
{------------------------------------------------------------------------------}
procedure TForm1.ComboBoxDeviceChange(Sender: TObject);
begin
  if TapiLine1.Active then
    CheckBoxActive.Checked := False;
  Memo1.Lines.Add('TapiLine1.DeviceID = ' + IntToStr(ComboBoxDevice.ItemIndex));
  TapiLine1.DeviceID := ComboBoxDevice.ItemIndex;
  if not TapiLine1.Available then
    Memo1.Lines.Add(#9 + 'Device not available')
  else
  begin
    TapiLine1.Privileges.Monitor := True;
    TapiLine1.Privileges.Owner := True;
  end;
end;

{------------------------------------------------------------------------------}
{ ButtonAnswerClick
{------------------------------------------------------------------------------}
procedure TForm1.ButtonAnswerClick(Sender: TObject);
begin
  Memo1.Lines.Add('Answering');
  if TapiLine1.Calls.Count > 0 then
  begin
    try
      TapiLine1.Calls[0].Answer;
    except
      on E:Exception do
        Memo1.Lines.Add(#9 + 'Error = ' + E.Message);
    end;
  end
  else
    Memo1.Lines.Add(#9 + 'No Call');
end;

{------------------------------------------------------------------------------}
{ ButtonHangupClick
{------------------------------------------------------------------------------}
procedure TForm1.ButtonHangupClick(Sender: TObject);
begin
  Memo1.Lines.Add('Hangup');
  if TapiLine1.Calls.Count > 0 then
  begin
    try
      TapiLine1.Calls[0].Drop;
    except
      on E:Exception do
        Memo1.Lines.Add(#9 + 'Error = ' + E.Message);
    end;
  end
  else
    Memo1.Lines.Add(#9 + 'No Call');
end;

{------------------------------------------------------------------------------}
{ ButtonClearClick
{------------------------------------------------------------------------------}
procedure TForm1.ButtonClearClick(Sender: TObject);
begin
  Memo1.Lines.Clear;
end;

procedure TForm1.TapiLine1MediaMode(Sender: TTapiLine; Call: TTapiCall);
begin
  Memo1.Lines.Add('TTapiLine.OnMediaMode');
  if (Call.MediaMode and LINEMEDIAMODE_G3FAX) = 0 then
    Memo1.Lines.Add(#9 + 'MediaMode <> LINEMEDIAMODE_G3FAX')
  else
    begin
        Memo1.Lines.Add(#9 + 'MediaMode = LINEMEDIAMODE_G3FAX');
        Memo1.Lines.Add('Call.HandOff(' + #39 + EditApplication.Text + #39 + ')');
        try
          Call.HandOff(EditApplication.Text);
        except
          on E:Exception do
            Memo1.Lines.Add(#9 + 'Error = ' + E.Message);
        end;
    end;
end;

procedure TForm1.TapiLine1Connected(Sender: TTapiLine; Call: TTapiCall);
begin
  Memo1.Lines.Add('TapiLine1.OnConnected');
  try
    Memo1.Lines.Add('Call.MonitorMedia.MediaModes := LINEMEDIAMODE_G3FAX');
    Memo1.Lines.Add('Call.MonitorMedia.Active := True');
    Call.MonitorMedia.MediaModes := LINEMEDIAMODE_G3FAX;
    Call.MonitorMedia.Active := True;
  except
    on E:Exception do
      Memo1.Lines.Add(#9 + 'Error = ' + E.Message)
  end;
end;

procedure TForm1.TapiLine1Idle(Sender: TTapiLine; Call: TTapiCall);
begin
  Memo1.Lines.Add('TapiLine1.OnIdle');
end;

procedure TForm1.TapiLine1Ring(Sender: TTapiLine; RingMode,
  RingCount: Cardinal);
begin
  Memo1.Lines.Add('TapiLine1.OnRing #' + IntToStr(RingCount));
end;

end.
